import pandas as pd
import numpy as np
import pickle
from decision_company import read_csv_file, assert_series, logical_or, to_list, fetch_index


atp_tennis = read_csv_file('atp_tennis.csv')

# Filter the DataFrame
federer_matches = atp_tennis[logical_or(assert_series(atp_tennis['Player_1'], 'Federer R.', 'equality'), assert_series(atp_tennis['Player_2'], 'Federer R.', 'equality'))]

# Get the index using the custom function
federer_match_ids_index = fetch_index(federer_matches)

# Convert the index to a list
federer_match_ids = to_list(federer_match_ids_index)

print(federer_match_ids)
pickle.dump(federer_match_ids,open("./ref_result/federer_match_ids.pkl","wb"))